% LOAD
wd = cd;
fwlog = sprintf('%s/log/frank_wolfe.log',wd(1:end-4));
data = load(fwlog);
iter = data(:,1);
scorePm = data(:,2);
scorePs = data(:,3);
tMin = data(:,4);

% PLOT
figure(2); clf;
set(gcf,'Position',[-1156 275 1050 1300]);
axes('Position',[0.24 0.12 0.72 0.82]);
lc = lines(8);
plot(tMin,scorePs,'o-','MarkerSize',12,...
  'LineWidth',2,'Color',lc(1,:),'MarkerFaceColor',lc(1,:),'MarkerEdgeColor',lc(1,:));
hold on;
plot(tMin,scorePm,'^-','MarkerSize',12,'LineWidth',2,...
  'Color',lc(7,:),'MarkerFaceColor',lc(7,:),'MarkerEdgeColor',lc(7,:));
set(gca,'FontSize',32);
set(gca,'LineWidth',3);
set(gca,'YTick',(51:2:59)*1e5);
set(gca,'XTick',0:3:9,'XLim',[0 9]);
set(gca,'YTickLabel',{'5100K','5300K','5500K','5700K','5900K'});
yl = ylabel('score');
xl = xlabel('minutes');
set(xl,'Position',[4.5 5050000 0]);
set(yl,'Position',[-2.25 5.5e6 0]);
plot([0 15],[5850000 5850000],'k--','LineWidth',2);
grid on;
lgd = legend(' doubly stochastic',' permutation');
set(lgd,'Position',[0.55 0.20 0.35 0.07]);
title('continuous relaxation');

% INSET
axes('Position',[0.53 0.5 0.4 0.3]);
plot(tMin,scorePs,'-','LineWidth',2,'Color',lc(1,:)); hold on;
plot(tMin,scorePm,'-','LineWidth',2,'Color',lc(7,:));
plot([0 60],[5850000 5850000],'k--','LineWidth',2);
set(gca,'YLim',[5830000 5860000]);
set(gca,'XTick',0:10:30,'XLim',[0 30]);
set(gca,'YTick',(58.3:0.1:58.6)*1e5);
set(gca,'YTickLabel',{'5830K','5840K','5850K','5860K'});
set(gcf,'PaperPositionMode','auto');
set(gcf,'PaperUnits','inches','PaperSize',[9 11.5]);
grid on;
set(gca,'LineWidth',3);
set(gca,'FontSize',20);
set(gca,'Color',[0.9 0.9 0.9]);
set(gcf,'Color','w');
set(gcf, 'InvertHardcopy','off');
xlabel('minutes');
print -dpdf fig_continuous.pdf;
